/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.service.serviceaction.repair.effectors;

import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.service.managedsystem.VerifyException;
import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.serviceaction.ProblemMonitor;
import com.ibm.hwmca.fw.service.serviceaction.ProblemVerificationFilter;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.service.SD;
import java.util.Map;

public class VerifyUtils {
    private static final String TRACE_MASKT = "XRVXVU_T";
    private static final String TRACE_MASKF = "XRVXVU_F";
    private static final String TRACE_MASKD = "XRVXVU_D";
    private static final LocalizableText[] progressIndicators = new LocalizableText[]{new LocalizableText("Started"), new LocalizableText("25 percent complete"), new LocalizableText("50 percent complete"), new LocalizableText("75 percent complete"), new LocalizableText("Complete")};

    public static String evaluateException(Map userData, VerifyException e) {
        Trace.trace(TRACE_MASKT, "-> VerifyUtils.evaluateException");
        String returnString = SD.CONTINUE;
        if (e.getRelatedProblems() != null) {
            Trace.trace(TRACE_MASKD, "VerifyUtils.evaluateException " + e.getRelatedProblems().size() + " related problem(s) detected");
            returnString = SD.NEW_PROBLEM_DETECTED;
        } else if (e.getDuplicateProblems() != null) {
            Trace.trace(TRACE_MASKD, "VerifyUtils.evaluateException " + e.getDuplicateProblems().size() + " duplicate problem(s) detected");
            returnString = SD.SAME_PROBLEM_DETECTED;
        } else {
            Trace.trace(TRACE_MASKD, "VerifyUtils.evaluateException unrelated problem(s) detected");
            returnString = SD.CONTINUE;
        }
        Trace.trace(TRACE_MASKT, "<- VerifyUtils.evaluate, returning: " + returnString);
        return returnString;
    }

    public static void defaultVerify(Map userData) throws VerifyException {
        Trace.trace(TRACE_MASKT, "-> VerifyUtils.defaultVerify");
        Problem p = (Problem)userData.get("SERVICEABLE_EVENT");
        ProblemMonitor pm = (ProblemMonitor)userData.get("PROBLEM_MONITOR");
        ProblemVerificationFilter pvf = (ProblemVerificationFilter)userData.get("PROBLEM_VERIFICATION_FILTER");
        if (p != null) {
            if (pm != null) {
                if (pvf != null) {
                    try {
                        pvf.test(p, pm, userData);
                    }
                    catch (VerifyException ve) {
                        Trace.trace(TRACE_MASKF, "VerifyUtils.defaultVerify VerifyException caught: " + ve);
                        if (!VerifyUtils.evaluateException(userData, ve).equals(SD.CONTINUE)) {
                            Trace.trace(TRACE_MASKT, "<-! VerifyUtils.defaultVerify - related or duplicate!");
                            userData.put("VERIFY_FAILURE_EXCEPTION", ve);
                            throw ve;
                        }
                        Trace.trace(TRACE_MASKF, "VerifyUtils.defaultVerify - unrelated - ignoring");
                    }
                } else {
                    Trace.trace(TRACE_MASKD, "VerifyUtils.defaultVerify no ProblemVerificationFilter defined in user data - skipping verify");
                }
            } else {
                Trace.trace(TRACE_MASKD, "VerifyUtils.defaultVerify no ProblemMonitor defined in user data - skipping verify");
            }
        } else {
            Trace.trace(TRACE_MASKD, "VerifyUtils.defaultVerify no Problem defined in user data - skipping verify");
        }
        Trace.trace(TRACE_MASKT, "<- VerifyUtils.defaultVerify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void defaultVerifyWithWait(Map userData, int secsToWait) throws VerifyException {
        if (secsToWait > 0) {
            try {
                int aii;
                int waitTime = secsToWait / progressIndicators.length;
                for (aii = 0; aii < progressIndicators.length - 1; ++aii) {
                    VerifyUtils.showBusy(userData, new LocalizableText("Waiting " + secsToWait / 60 + " minutes for the system to log errors.  " + "Verification progress:  " + progressIndicators[aii].toString()));
                    Thread.sleep(waitTime * 1000);
                    VerifyUtils.defaultVerify(userData);
                    VerifyUtils.destroyBusy(userData);
                }
                VerifyUtils.showBusy(userData, new LocalizableText("Verification progress:  " + progressIndicators[aii].toString()));
                VerifyUtils.defaultVerify(userData);
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                VerifyUtils.destroyBusy(userData);
            }
        } else {
            VerifyUtils.defaultVerify(userData);
        }
    }

    private static void showBusy(Map userData, LocalizableText msg) {
        try {
            GenericGui guiHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
            guiHandle.showBusyDialog(new LocalizableText("Verification progress"), msg, userData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void destroyBusy(Map userData) {
        try {
            GenericGui guiHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
            guiHandle.destroyBusyDialog(userData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

